#delimit ;
cap log close ;
log using table2.log, text replace ;

clear ;
set seed 10101 ;
set more off ;

/* load up the programs. each do file has a program that will be used */

do set_directory_macros ;
set matsize 10000 ;
run t2_mcloop ;
run CR23_IK_CSS ;
run t2_display ;

cap prog drop runme ;
prog def runme ;

/* initialize the file names, lists, etc, that will be passed into the pgrograms */

local num_mc_reps = 100 ;
local mc_reps_smallG = 4000 ;
local mc_reps_bigG = 1000 ;

local num_bs_reps = 399 ;
*local num_states_list = "6 " ;
local num_states_list = "6 10 20 30 50" ;
*local mysourcedata = "$madedat/CPS_2012_micro_small" ;
local mysourcedata = "$madedat/CPS_2012_micro_medium" ;

/* ensure that the source data file is sorted on statefip  */
tempfile statelist ;
qui use "`mysourcedata'" ;
cap drop resid ;
sort statefip ;
qui save "`mysourcedata'" , replace ;

/* now, do the Monte Carlo exercise*/
/* loop over number of states in the hum_states_list*/

foreach ns in `num_states_list' { ;

	/* do more MC reps for 6 and 10 states */
	local num_mc_reps = `mc_reps_bigG' ;
	if `ns' < 11 { ;
		local num_mc_reps = `mc_reps_smallG' ;
	} ;
		

	tempfile mcout_`ns' ;
	di ;
	di "$S_DATE $S_TIME" ;
	do_the_monte_carlo , sourcedata("`mysourcedata'") savedata("`mcout_`ns''")
		mcreps(`num_mc_reps') bsreps(`num_bs_reps') numstates(`ns') ;

	use `mcout_`ns'' , replace ;
	qui gen datetime = "$S_DATE $S_TIME" ;		/* keeps track of when this batch of data was generated */
	qui save "`mcout_`ns''" , replace ;

	qui save t2_mcout_G_`ns' , replace ;
} ;


/* this next loop will go through the "statelist" and swap-in the results into to_mcout_all 
	this is to enable these results to be done in batches, in parallell.  We just swap in those results in the list, 
	leaving any results already in the file (and not in num_states_list) untouched.  */
tempfile toappend ;
foreach ns in `num_states_list' { ;
	clear ;
	cap erase `toappend' ;
	cap use t2_mcout_all ;
	cap drop if numstates == `ns' ;
	cap save `toappend' , replace ;
	use t2_mcout_G_`ns' ;
	cap append using `toappend' ;
	qui save t2_mcout_all , replace ;
	
} ;


display_results , results_data(t2_mcout_all) 
	numstates_list("`num_states_list'") sourcedata("`mysourcedata'");

end ;

runme ;


log close ;

